#pragma once

#include <ymod_webserver/methods.h>
#include <ymod_webserver/server.h>

#include <string>
#include <vector>

namespace NRateSrv::NHandlers::NHttp {

using EHttpMethod = ymod_webserver::methods::http_method;
using THttpStreamPtr = ymod_webserver::http::stream_ptr;
using THttpPaths = std::vector<std::string>;

class IHandler {
public:
    virtual ~IHandler() = default;

    virtual THttpPaths Paths() const = 0;
    virtual EHttpMethod Method() const = 0;
    virtual bool NeedTvm() const = 0;
    virtual void Execute(THttpStreamPtr stream) = 0;
};

} // namespace NRateSrv::NHandlers::NHttp
