#include "callbacks.h"

namespace NRateSrv::NHandlers::NJson {

TCounterRequest TCallbacks::GetRequest() {
    TCounterRequest request;
    std::swap(request, Request);
    return request;
}

TParseError TCallbacks::GetLastError() {
    TParseError error;
    std::swap(error, Error);
    return error;
}

bool TCallbacks::OnNull() {
    return false;
}

bool TCallbacks::OnBoolean(bool) {
    return false;
}

bool TCallbacks::OnDouble(double) {
    return false;
}

bool TCallbacks::OnOpenArray() {
    return false;
}

bool TCallbacks::OnCloseArray() {
    return false;
}

void TCallbacks::OnError(size_t off, TStringBuf reason) {
    Error.first = off;
    if (Error.second.empty()) {
        Error.second = std::string(reason.data(), reason.size());
    }
}

TCounterData& TCallbacks::GetCounter() {
    return Counter;
}

std::string& TCallbacks::GetId() {
    return Id;
}

bool TCallbacks::AddCounterToRequest() {
    TCounterData counter;
    std::string id;
    std::swap(counter, Counter);
    std::swap(id, Id);

    return Request.emplace(std::move(id), std::move(counter)).second;
}

void TCallbacks::SetError(size_t offset, std::string reason) {
    TParseError error(offset, std::move(reason));
    std::swap(error, Error);
}

} // namespace NRateSrv::NHandlers::NJson
