#pragma once

#include <mail/ratesrv/src/common/types.h>

#include <library/cpp/json/common/defs.h>

#include <string>
#include <utility>

namespace NRateSrv::NHandlers::NJson {

using TParseError = std::pair<size_t, std::string>;

class TCallbacks : public ::NJson::TJsonCallbacks {
public:
    TCounterRequest GetRequest();
    TParseError GetLastError();

    bool OnNull() override final;
    bool OnBoolean(bool) override final;
    bool OnDouble(double) override final;
    bool OnOpenArray() override final;
    bool OnCloseArray() override final;

    void OnError(size_t off, TStringBuf reason) override final;

protected:
    TCounterData& GetCounter();
    std::string& GetId();

    bool AddCounterToRequest();
    void SetError(size_t offset, std::string reason);

private:
    TParseError Error;
    TCounterRequest Request;
    TCounterData Counter;
    std::string Id;
};

} // namespace NRateSrv::NHandlers::NJson
