#include "get_callbacks.h"

namespace NRateSrv::NHandlers::NJson {

bool TGetCallbacks::OnInteger(long long) {
    return false;
}

bool TGetCallbacks::OnUInteger(unsigned long long) {
    return false;
}

bool TGetCallbacks::OnString(const TStringBuf& val) {
    if (State != EState::WaitCounterName) {
        return false;
    }

    if (!val) {
        SetError(0, "Counter name must not be empty");
        return false;
    }

    GetCounter().Name = std::string(val.data(), val.size());

    if (AddCounterToRequest()) {
        State = EState::WaitCounterId;
        return true;
    }

    SetError(0, "Counter id must be unique");
    return false;
}

bool TGetCallbacks::OnOpenMap() {
    if (State == EState::Init) {
        State = EState::WaitCountersMapKey;
    } else if (State == EState::WaitCountersMapOpen) {
        State = EState::WaitCounterId;
    } else {
        return false;
    }

    return true;
}

bool TGetCallbacks::OnMapKey(const TStringBuf& val) {
    if (State == EState::WaitCountersMapKey) {
        if (val != "counters") {
            return false;
        }
        State = EState::WaitCountersMapOpen;

    } else if (State == EState::WaitCounterId) {
        if (!val) {
            SetError(0, "Counter id must not be empty");
            return false;
        }

        GetId() = static_cast<std::string>(val);
        State = EState::WaitCounterName;

    } else {
        return false;
    }

    return true;
}

bool TGetCallbacks::OnCloseMap() {
    if (State == EState::WaitCountersMapClose) {
        State = EState::End;
    } else if (State == EState::WaitCounterId) {
        State = EState::WaitCountersMapClose;
    } else {
        return false;
    }

    return true;
}

} // namespace NRateSrv::NHandlers::NJson
