#pragma once

#include "callbacks.h"

#include <mail/ratesrv/src/common/types.h>

namespace NRateSrv::NHandlers::NJson {

class TGetCallbacks : public TCallbacks {
public:
    enum class EState {
        Init,
        WaitCountersMapKey,
        WaitCountersMapOpen,
        WaitCounterId,
        WaitCounterName,
        WaitCountersMapClose,
        End,
    };

    bool OnInteger(long long val) override;
    bool OnUInteger(unsigned long long val) override;
    bool OnString(const TStringBuf& val) override;
    bool OnOpenMap() override;
    bool OnMapKey(const TStringBuf& val) override;
    bool OnCloseMap() override;

private:
    EState State = EState::Init;
};

} // namespace NRateSrv::NHandlers::NJson
