#include "increase_callbacks.h"

namespace NRateSrv::NHandlers::NJson {

bool TIncreaseCallbacks::OnInteger(long long val) {
    if (State != EState::WaitCounterValue) {
        return false;
    }

    if (val <= 0) {
        SetError(0, "Counter value must be greater than zero");
        return false;
    }

    GetCounter().Value = val;
    State = EState::WaitCounterMapClose;

    return true;
}

bool TIncreaseCallbacks::OnUInteger(unsigned long long val) {
    if (State != EState::WaitCounterValue) {
        return false;
    }

    if (val == 0) {
        SetError(0, "Counter value must be greater than zero");
        return false;
    }

    GetCounter().Value = val;
    State = EState::WaitCounterMapClose;

    return true;
}

bool TIncreaseCallbacks::OnString(const TStringBuf& val) {
    if (State != EState::WaitCounterName) {
        return false;
    }

    if (!val) {
        SetError(0, "Counter name must not be empty");
        return false;
    }

    GetCounter().Name = std::string(val.data(), val.size());
    State = EState::WaitCounterValueKey;

    return true;
}

bool TIncreaseCallbacks::OnOpenMap() {
    if (State == EState::Init) {
        State = EState::WaitCountersMapKey;
    } else if (State == EState::WaitCountersMapOpen) {
        State = EState::WaitCounterId;
    } else if (State == EState::WaitCounterMapOpen) {
        State = EState::WaitCounterNameKey;
    } else {
        return false;
    }

    return true;
}

bool TIncreaseCallbacks::OnMapKey(const TStringBuf& val) {
    if (State == EState::WaitCountersMapKey) {
        if (val != "counters") {
            return false;
        }
        State = EState::WaitCountersMapOpen;

    } else if (State == EState::WaitCounterId) {
        if (!val) {
            SetError(0, "Counter id must not be empty");
            return false;
        }

        GetId() = static_cast<std::string>(val);
        State = EState::WaitCounterMapOpen;

    } else if (State == EState::WaitCounterNameKey) {
        if (val != "name") {
            return false;
        }
        State = EState::WaitCounterName;

    } else if (State == EState::WaitCounterValueKey) {
        if (val != "value") {
            return false;
        }
        State = EState::WaitCounterValue;

    } else {
        return false;
    }

    return true;
}

bool TIncreaseCallbacks::OnCloseMap() {
    if (State == EState::WaitCountersMapClose) {
        State = EState::End;
    } else if (State == EState::WaitCounterId) {
        State = EState::WaitCountersMapClose;
    } else if (State == EState::WaitCounterMapClose) {
        if (!AddCounterToRequest()) {
            SetError(0, "Counter id must be unique");
            return false;
        }

        State = EState::WaitCounterId;

    } else {
        return false;
    }

    return true;
}

} // namespace NRateSrv::NHandlers::NJson
