#include "request_parser.h"

#include <mail/ratesrv/src/common/input_segment_stream.h>

#include <library/cpp/json/json_reader.h>

namespace NRateSrv::NHandlers::NJson {

bool ParseRequest(const yplatform::zerocopy::segment& body, ::NJson::TJsonCallbacks* callbacks) {
    Y_ASSERT(callbacks != nullptr);

    TInputSegmentStream stream(body);

    ::NJson::TJsonReaderConfig config;
    config.AllowComments = false;
    config.DontValidateUtf8 = true;

    return ::NJson::ReadJson(&stream, &config, callbacks);
}

} // namespace NRateSrv::NHandlers::NJson
