#include "response_maker.h"

#include <mail/ratesrv/src/common/output_string_stream.h>

#include <library/cpp/json/json_writer.h>

#include <util/string/cast.h>

#include <string>

namespace NRateSrv::NHandlers::NJson {

std::string MakeCounterValuesResponse(const TCounterResponse& response) {
    std::string res;
    TOutputStringStream stream(res);

    ::NJson::TJsonWriterConfig config;
    config.ValidateUtf8 = false;

    ::NJson::TJsonWriter writer(&stream, config);

    writer.OpenMap();
    writer.Write("counters");
    writer.OpenMap();

    for (const auto& [id, value] : response) {
        writer.Write(id.c_str());
        writer.OpenMap();

        bool writeValues = false;
        writer.Write("status");

        if (value.State == ECounterState::Ok) {
            writeValues = true;
            writer.Write("ok");

        } else if (value.State == ECounterState::Exceeded) {
            writeValues = true;
            writer.Write("exceeded");

        } else {
            writer.Write("error");
            writer.Write("description");
            writer.Write(ToString(value.State));
        }

        if (writeValues) {
            writer.Write("current", value.Current);
            writer.Write("available", value.Available);
        }

        writer.CloseMap();
    }

    writer.CloseMap();
    writer.CloseMap();
    writer.Flush();

    return res;
}

} // namespace NRateSrv::NHandlers::NJson
