#include "host_checker_impl.h"

namespace NRateSrv::NInstances {

namespace {

auto MakeRequest(std::string host) {
    return ymod_httpclient::request::GET(host + "/ping");
}

} // namespace anonymous

THostChecker::THostChecker(TClientPtr client, boost::asio::io_context& io)
    : Client(std::move(client))
    , Io(io) {}

void THostChecker::AsyncCheck(TContextPtr context, std::string host, TCallback callback) {
    auto handler = [ex = Io.get_executor(), callback = std::move(callback)]
        (auto ec, auto response) {
            boost::asio::post(ex, std::bind(&THostChecker::HandleAsyncCheck, callback, std::move(ec), std::move(response)));
        };
    Client->async_run(context, MakeRequest(std::move(host)), std::move(handler));
}

void THostChecker::HandleAsyncCheck(TCallback callback, boost::system::error_code ec, yhttp::response resp) {
    if (ec || resp.status != 200) {
        callback(false);
    } else {
        callback(true); 
    }
}

} // namespace NRateSrv::NInstances
