#pragma once

#include <mail/ratesrv/src/instances/host_checker.h>

#include <mail/ymod_httpclient/include/ymod_httpclient/client.h>

#include <boost/asio.hpp>

#include <memory>

namespace NRateSrv::NInstances {

struct THostChecker : IHostChecker {
    using TClientPtr = std::shared_ptr<ymod_httpclient::simple_call>;

    THostChecker(TClientPtr client, boost::asio::io_context& io);

    void AsyncCheck(TContextPtr context, std::string host, TCallback callback) override;
private:
    static void HandleAsyncCheck(TCallback callback, boost::system::error_code ec, yhttp::response resp);

    TClientPtr Client;
    boost::asio::io_context& Io;
};

} // namespace NRateSrv::NInstances
