#pragma once

#include <mail/ratesrv/src/context.h>

#include <functional>
#include <memory>
#include <string>

namespace NRateSrv::NInstances {

struct IHostChecker {
    using TCallback = std::function<void(bool)>;

    virtual ~IHostChecker() = default;
    virtual void AsyncCheck(TContextPtr, std::string, TCallback) = 0;
};

using THostCheckerPtr = std::shared_ptr<IHostChecker>;

} // namespace NRateSrv::NInstances
