#pragma once

#include "types.h"

#include <mail/ratesrv/src/context.h>

#include <functional>
#include <memory>
#include <string>

namespace NRateSrv::NInstances {

struct IHostGetter {
    using TCallback = std::function<void(boost::system::error_code, THosts)>;

    virtual ~IHostGetter() = default;
    virtual void AsyncGet(TContextPtr, TCallback) = 0;
    virtual std::string LocalHost() = 0;
};

using THostGetterPtr = std::shared_ptr<IHostGetter>;

} // namespace NRateSrv::NInstances
