#include "hostlist_builder.h"

#include "mail/ratesrv/src/instances/qloud/errors.h"

#include <yplatform/yield.h>

#include <algorithm>
#include <cstdlib>

namespace NRateSrv::NInstances {

THostListBuilder::THostListBuilder(
    TContextPtr context,
    THostGetterPtr hostGetter,
    THostCheckerPtr hostChecker,
    TCallback callback
)
    : Context(std::move(context))
    , HostGetter(std::move(hostGetter))
    , HostChecker(std::move(hostChecker))
    , Callback(std::move(callback))
{}

void THostListBuilder::operator()(TYieldCtx yieldCtx) {
    reenter (yieldCtx) {

        yield HostGetter->AsyncGet(Context, yieldCtx.capture(ErrorCode, Instances));
        if (ErrorCode) {
            yield break;
        }
        for (CurrentInstance = Instances.begin(); CurrentInstance != Instances.end(); ++CurrentInstance) {
            yield HostChecker->AsyncCheck(Context, *CurrentInstance, yieldCtx.capture(InstancesStatus));
            if (InstancesStatus) {
                Hosts.push_back(*CurrentInstance);
            };
        }
    }

    if (yieldCtx.is_complete()) {
        if (ErrorCode) {
            return Callback(ErrorCode, TResponse{});
        }
        auto clusterUsagePersent = Instances.size() > 0 ? (Hosts.size() * 100 / Instances.size()) : 0;
 
        Callback(ErrorCode, TResponse{
            .LocalHost = HostGetter->LocalHost(),
            .Hosts = Hosts,
            .ClusterUsagePersent = clusterUsagePersent
        });
    }
}

} // namespace NRateSrv::NInstances
