#pragma once

#include "host_checker.h"
#include "host_getter.h"
#include "types.h"

#include <yplatform/coroutine.h>

#include <functional>
#include <string>
#include <vector>

namespace NRateSrv::NInstances {

class THostListBuilder {
public:
    using TCallback = std::function<void(boost::system::error_code, TResponse)>;
    using TYieldCtx = yplatform::yield_context<THostListBuilder>;

    THostListBuilder(
        TContextPtr context,
        THostGetterPtr hostGetter,
        THostCheckerPtr hostChecker,
        TCallback callback
    );

    void operator()(TYieldCtx yieldCtx);

private:
    void HandleResponse();

private:
    TContextPtr Context;
    THostGetterPtr HostGetter;
    THostCheckerPtr HostChecker;
    TCallback Callback;

    boost::system::error_code ErrorCode;
    THosts Instances;
    THosts::iterator CurrentInstance;
    bool InstancesStatus = false;
    THosts Hosts;
};

using THostListBuilderPtr = std::shared_ptr<THostListBuilder>;

} // namespace NRateSrv::NInstances
