#include "errors.h"

namespace NRateSrv::NInstances::NQloud {


class TErrorCategory : public boost::system::error_category {
public:
    const char* name() const noexcept override {
        return "qloud_api";
    }

    std::string message(int value) const override {
        switch (static_cast<EError>(value)) {
            case EError::Ok:
                return "Ok";
            case EError::ParseError:
                return "Fail to parse response";
            case EError::UnknownState:
                return "Unknown instance state";
            case EError::EmptyFQDN:
                return "Empty FQDN";
            case EError::InvalidID:
                return "Invalid ID";
            case EError::HttpError:
                return "Http error";
        }

        return "Unknown error";
    }
};

const TErrorCategory& getErrorCategory() {
    static TErrorCategory errorCategory;
    return errorCategory;
}

boost::system::error_code make_error_code(EError code) {
    return boost::system::error_code(static_cast<int>(code), getErrorCategory());
}

} // namespace NRateSrv::NInstances::NQloud
