#pragma once

#include <boost/system/error_code.hpp>

namespace NRateSrv::NInstances::NQloud {

enum EError {
    Ok,
    ParseError,
    UnknownState,
    EmptyFQDN,
    InvalidID,
    HttpError
};

boost::system::error_code make_error_code(EError code);

} // namespace NRateSrv::NInstances::NQloud

namespace boost::system {

template <>
struct is_error_code_enum<NRateSrv::NInstances::NQloud::EError> : std::true_type{};

} // namespace boost::system
