#include "errors.h"
#include "host_getter_impl.h"
#include "parser.h"

#include <cstdlib>

namespace NRateSrv::NInstances::NQloud {

THostGetter::THostGetter(TClientPtr client, boost::asio::io_context& io)
    : Client(std::move(client))
    , Io(io) {}

void THostGetter::AsyncGet(TContextPtr context, TCallback callback) {
    auto handler = [ex = Io.get_executor(), callback = std::move(callback)]
        (auto ec , auto response) {
            boost::asio::post(ex, std::bind(&THostGetter::HandleAsyncGet, callback, std::move(ec), std::move(response)));
        };
    Client->async_run(context, ymod_httpclient::request::GET("/metadata"), std::move(handler));
}

void THostGetter::HandleAsyncGet(TCallback callback, boost::system::error_code ec, yhttp::response response) {
    if (ec) {
        return callback(ec, {});
    }
    auto [error, rawInstances] = ParseResponse(response);
    if (error) {
        return callback(error, {});
    }
    callback({}, ReduceInstances(std::move(rawInstances)));
}

std::string THostGetter::LocalHost() {
    const auto localHost = std::getenv("QLOUD_HOSTNAME");
    return localHost != nullptr ? localHost : "";
}

} // namespace NRateSrv::NInstances::NQloud
