#pragma once

#include <mail/ratesrv/src/instances/host_getter.h>

#include <mail/ymod_httpclient/include/ymod_httpclient/cluster_client.h>

#include <boost/asio.hpp>

namespace NRateSrv::NInstances::NQloud {

struct THostGetter: IHostGetter {
    using TClientPtr = std::shared_ptr<ymod_httpclient::cluster_call>;

    THostGetter(TClientPtr client, boost::asio::io_context& io);

    void AsyncGet(TContextPtr context, TCallback callback) override;
    std::string LocalHost() override;
private:
    static void HandleAsyncGet(TCallback callback, boost::system::error_code ec, yhttp::response response);

    TClientPtr Client;
    boost::asio::io_context& Io;
};

} // namespace NRateSrv::NInstances
