#pragma once

#include "errors.h"

#include <mail/ratesrv/src/instances/types.h>

#include <ymod_httpclient/call.h>

#include <list>
#include <map>
#include <string>

namespace NRateSrv::NInstances::NQloud {

enum class EState {
    New,
    Existing,
    Residing,
};

using TInstance = std::pair<EState, std::string>;
using TInstances = std::multimap<uint64_t, TInstance>;
using TParseRes = std::pair<EError, TInstances>;

TParseRes ParseResponse(const yhttp::response& response);
TParseRes ParseSuccessResponse(const std::string& body);

THosts ReduceInstances(TInstances instances);

} // namespace NRateSrv::NInstances
