#include "task.h"

#include <mail/ratesrv/src/instances/hostlist_builder.h>
#include <mail/ratesrv/src/instances/checker/host_checker_impl.h>
#include <mail/ratesrv/src/instances/qloud/host_getter_impl.h>

#include <yplatform/coroutine.h>
#include <yplatform/find.h>

namespace NRateSrv::NInstances {

TTask::TTask(TCallback callback, boost::asio::io_context& io)
    : Callback(std::move(callback))
    , Io(io) {}

void TTask::Run() {
    if (Cancelled.load(std::memory_order_acquire)) {
        return;
    }

    auto hostChecker = std::make_shared<NInstances::THostChecker>(
        yplatform::find<yhttp::simple_call, std::shared_ptr>("host_checker_client"),
        Io
    );

    auto hostGetter = std::make_shared<NInstances::NQloud::THostGetter>(
        yplatform::find<ymod_httpclient::cluster_call, std::shared_ptr>("host_getter_client"),
        Io
    );

    auto builder = std::make_shared<NInstances::THostListBuilder>(
        boost::make_shared<NRateSrv::TContext>(),
        std::move(hostGetter),
        std::move(hostChecker),
        Callback
    );
    yplatform::spawn(Io, std::move(builder));
}

void TTask::Cancel() {
    Cancelled.store(true, std::memory_order_release);
}

} // namespace NRateSrv::NInstances

