#pragma once

#include "types.h"

#include <mail/ratesrv/src/scheduler/task.h>

#include <boost/asio.hpp>

#include <atomic>

namespace NRateSrv::NInstances {

struct TTask : NScheduler::ITask {
    using TCallback = std::function<void(boost::system::error_code, TResponse)>;

    TTask(TCallback callback, boost::asio::io_context& io);
    void Run() override;
    void Cancel() override;

private:
    TCallback Callback;
    boost::asio::io_context& Io;
    std::atomic_bool Cancelled = false;
};

} // namespace NRateSrv::NInstances
