#pragma once

#include "context.h"

#include <yplatform/log.h>
#include <yplatform/task_context.h>
#include <yplatform/tskv/tskv.h>

#include <logdog/format/tskv.h>
#include <logdog/logger.h>
#include <logdog/attributes/mail_attributes.h>
#include <logdog/backend/yplatform_log.h>

namespace NRateSrv::NLogging {

constexpr static auto RATESRV_FORMATTER = logdog::tskv::make_formatter(BOOST_HANA_STRING("ratesrv"));

using logdog::attr::message;
LOGDOG_DEFINE_ATTRIBUTE(std::string, counter_name)
LOGDOG_DEFINE_ATTRIBUTE(int64_t, counter_value)

inline auto makeLogger(const std::string& name) {
    return logdog::make_log(
        RATESRV_FORMATTER, 
        yplatform::log::source {YGLOBAL_LOG_SERVICE, name}
    );
}

inline auto makeLoggerFromContext(TContextPtr ctx, const std::string& name) {
    return logdog::bind(
        logdog::make_log(
            RATESRV_FORMATTER, 
            yplatform::log::source {YGLOBAL_LOG_SERVICE, name}
        ), 
        logdog::context_id = ctx->uniq_id());
}

}

#define RATESRV_LOG_COUNTER(ctx, level, cnt_name, cnt_value) \
    LOGDOG_(::NRateSrv::NLogging::makeLoggerFromContext(ctx, "ratesrv"), level, \
        NRateSrv::NLogging::counter_name = (cnt_name), \
        NRateSrv::NLogging::counter_value = (cnt_value) \
)

#define RATESRV_LOG_COUNTER_NOCTX(level, cnt_name, cnt_value) \
    LOGDOG_(::NRateSrv::NLogging::makeLogger("ratesrv"), level, \
        NRateSrv::NLogging::counter_name = (cnt_name), \
        NRateSrv::NLogging::counter_value = (cnt_value) \
)
