#pragma once

#include <yplatform/time_traits.h>

#include <util/system/types.h>

#include <memory>
#include <string>

namespace NRateSrv::NRouter {

class TConfiguration {
public:
    using TBanDuration = yplatform::time_traits::duration;
    using TTimeout = yplatform::time_traits::duration;

    inline ui64 GetHashSeed() const {
        return HashSeed;
    }

    inline void SetHashSeed(ui64 seed) {
        HashSeed = seed;
    }

    inline size_t GetBucketCount() const {
        return BucketCount;
    }

    inline void SetBucketCount(size_t bucketCount) {
        BucketCount = bucketCount;
    }

    inline TBanDuration GetBaseBanDuration() const {
        return BaseBanDuration;
    }

    inline void SetBaseBanDuration(TBanDuration duration) {
        BaseBanDuration = duration;
    }

    inline void SetBanQuorum(size_t banQuorum) {
        BanQuorum = banQuorum;
    }

    inline size_t GetBanQuorum() const {
        return BanQuorum;
    }

    inline void SetNodeHashSalt(std::string salt) {
        NodeHashSalt = std::move(salt);
    }

    inline std::string GetNodeHashSalt() const {
        return NodeHashSalt;
    }

    inline void SetTimeout(TTimeout timeout) {
        Timeout = timeout;
    }

    inline TTimeout GetTimeout() const {
        return Timeout;
    }

    inline void SetPingTimeout(TTimeout timeout) {
        PingTimeout = timeout;
    }

    inline TTimeout GetPingTimeout() const {
        return PingTimeout;
    }

    inline void SetMaxAttemptsForNode(size_t attempts) {
        MaxAttemptsForNode = attempts;
    }

    inline size_t GetMaxAttemptsForNode() const {
        return MaxAttemptsForNode;
    }

    inline void SetMaxAttempts(size_t attempts) {
        MaxAttempts = attempts;
    }

    inline size_t GetMaxAttempts() const {
        return MaxAttempts;
    }

private:
    ui64 HashSeed = 0;
    size_t BucketCount = 1000;
    TBanDuration BaseBanDuration = TBanDuration::zero();
    TTimeout Timeout = TTimeout::zero();
    TTimeout PingTimeout = TTimeout::zero();
    std::string NodeHashSalt;
    size_t MaxAttemptsForNode = 1;
    size_t MaxAttempts = 1;
    size_t BanQuorum = 1;
};

using TConfigurationPtr = std::shared_ptr<TConfiguration>;

} // namespace NRateSrv::NRouter
