#pragma once

#include "network_agent.h"
#include "node_manager.h"
#include "configuration.h"
#include "common.h"

#include <mail/ratesrv/src/storage/protocol.h>
#include <mail/ratesrv/src/common/types.h>
#include <mail/ratesrv/src/context.h>

#include <yplatform/task_context.h>
#include <yplatform/reactor.h>
#include <yplatform/coroutine.h>
#include <yplatform/time_traits.h>

#include <boost/asio/io_context_strand.hpp>

#include <functional>
#include <unordered_map>
#include <vector>

namespace NRateSrv::NRouter {

class TCountersWorker {
public:
    using TTaskContextPtr = TContextPtr;
    using TYieldCtx = yplatform::yield_context<TCountersWorker>;

    TCountersWorker(
        yplatform::reactor& reactor,
        TConfigurationPtr configuration,
        TNetworkAgentPtr networkAgent,
        TNodeManagerPtr nodeManager,
        TTaskContextPtr ctx,
        TCounterRequest request,
        ERequestMode mode,
        TCallback callback);

    void operator()(TYieldCtx yieldCtx);

private:
    void SplitRequest(TYieldCtx yieldCtx);
    void SendToDestination(TYieldCtx yieldCtx);
    void Complete();

    void SendToRemoteNode(size_t nodeNum, NStorage::TRequest request, TYieldCtx yieldCtx);
    void SendToLocalStorage(NStorage::TRequest request, size_t failsCount, TYieldCtx yieldCtx);

    void HandleValues(size_t failsCount, NStorage::TResponse response, TYieldCtx yieldCtx);

    void WriteLog();

private:
    yplatform::reactor& Reactor;
    boost::asio::io_context::strand Strand;

    TConfigurationPtr Configuration;
    TNetworkAgentPtr NetworkAgent;
    TNodeManagerPtr NodeManager;

    TTaskContextPtr Ctx;
    TCounterRequest Request;
    size_t RequestSize;
    ERequestMode Mode;
    TCallback Callback;

    std::vector<std::string> Ids;
    NStorage::TResponse StorageResponse;

    std::unordered_map<size_t, NStorage::TRequest> Parts;

    bool HasLocalPart;
    size_t FailsCount;
    size_t ReadyParts;

    std::unordered_map<ECounterState, size_t> StatesCount;
    TCounterResponse Response;
};

} // namespace NRateSrv::NRouter
