#include "messenger_request_handler.h"
#include "storage_client.h"

#include <mail/ratesrv/src/logger.h>

#include <spdlog/details/format.h>

#include <yplatform/context_repository.h>
#include <yplatform/find.h>
#include <yplatform/log.h>
#include <yplatform/yield.h>

#include <util/string/cast.h>

#include <unordered_map>

namespace NRateSrv::NRouter {

TMessengerRequestHandler::TMessengerRequestHandler(
    std::string address,
    TMessengerRequest request,
    ERequestMode mode,
    TStorageCallback callback
)
    : Address(std::move(address))
    , Request(std::move(request))
    , Mode(mode)
    , Callback(std::move(callback))
    , Ctx(new TContext(Request.ContextId))
{
}

void TMessengerRequestHandler::operator()(TYieldCtx yieldCtx, TStorageResponse response) {
    reenter (yieldCtx) {
        {
            auto prefix = static_cast<std::string>(ToString(Mode));
            RATESRV_LOG_COUNTER(Ctx, notice, prefix + "_node_requests", 1);
        }

        yield SendToStorage(yieldCtx);

        Response = std::move(response).value();

        Callback(std::move(Response));
    }
}

void TMessengerRequestHandler::SendToStorage(TCallback callback) {
    auto storageClient = std::make_shared<TStorageClient>(std::move(Request.StorageRequest), Mode, std::move(callback));
    yplatform::spawn(storageClient);
}

} // namespace NRateSrv::NRouter
