#pragma once

#include "network_protocol.h"
#include "common.h"

#include <mail/ratesrv/src/context.h>

#include <yplatform/task_context.h>
#include <yplatform/coroutine.h>

#include <functional>
#include <optional>

namespace NRateSrv::NRouter {

class TMessengerRequestHandler {
public:
    using TStorageResponse = std::optional<NStorage::TResponse>;
    using TCallback = std::function<void(TStorageResponse response)>;
    using TYieldCtx = yplatform::yield_context<TMessengerRequestHandler>;

    TMessengerRequestHandler(
        std::string address,
        TMessengerRequest request,
        ERequestMode mode,
        TStorageCallback callback);

    void operator()(TYieldCtx yieldCtx, TStorageResponse response = {});

private:
    void SendToStorage(TCallback callback);

private:
    std::string Address;
    TMessengerRequest Request;
    ERequestMode Mode;
    TStorageCallback Callback;

    TContextPtr Ctx;
    NStorage::TResponse Response;
};

} // namespace NRateSrv::NRouter
