#pragma once

#include "node_manager.h"
#include "network_protocol.h"
#include "common.h"

#include <mail/ratesrv/src/context.h>
#include <mail/ratesrv/src/storage/protocol.h>

#include <yplatform/task_context.h>

#include <functional>
#include <memory>

namespace NRateSrv::NRouter {

class INetworkAgent {
public:
    using TCallback = std::function<void(ui64 requestId, NStorage::TResponse response)>;
    using TTaskContextPtr = TContextPtr;

    virtual ~INetworkAgent() = default;

    virtual ui64 SendRequest(
        TNodeManagerPtr nodeManager,
        TTaskContextPtr ctx,
        size_t nodeNum,
        NStorage::TRequest request,
        EMessageTypes type,
        TCallback callback) = 0;

    virtual TCallback CompleteRequest(ui64 requestId, bool success) = 0;
};

using TNetworkAgentPtr = std::shared_ptr<INetworkAgent>;

} // namespace NRateSrv::NRouter
