#pragma once

#include "network_agent.h"
#include "configuration.h"
#include "common.h"

#include <mail/ratesrv/src/common/types.h>

#include <util/system/guard.h>
#include <util/system/spinlock.h>

#include <yplatform/reactor.h>
#include <yplatform/log.h>

#include <memory>
#include <string>
#include <unordered_map>
#include <vector>

namespace NRateSrv::NRouter {

class TNetworkAgentImpl :
    public INetworkAgent,
    public std::enable_shared_from_this<TNetworkAgentImpl>,
    public yplatform::log::contains_logger
{
public:
    TNetworkAgentImpl(
        yplatform::reactor& reactor,
        const yplatform::log::source& logger,
        TConfigurationPtr configuration);

    void InitNodeManager(const std::string& localhost, std::vector<std::string> hosts);
    void Listen();

    ui64 SendRequest(
        TNodeManagerPtr nodeManager,
        TTaskContextPtr ctx,
        size_t nodeNum,
        NStorage::TRequest request,
        EMessageTypes type,
        TCallback callback) override;

    TCallback CompleteRequest(ui64 requestId, bool success) override;

    TNodeManagerPtr GetNodeManager();

private:
    struct TRequest {
        size_t NodeNum;
        TNodeManagerPtr NodeManager;
        std::string ContextId;
        NStorage::TRequest Request;
        EMessageTypes Type;
        TCallback Callback;
    };

    void BindRequestMessages(bool increase);
    void BindResponseMessages();

    ui64 CreateRequest(size_t nodeNum, TNodeManagerPtr nodeManager, std::string contextId, NStorage::TRequest request, EMessageTypes type, TCallback callback);
    void SendResponse(const std::string& address, ui64 requestId, NStorage::TResponse response);

private:
    yplatform::reactor& Reactor;
    TConfigurationPtr Configuration;

    TAdaptiveLock RequestLock;
    std::unordered_map<ui64, TRequest> Requests;

    TAdaptiveLock NodeManagerLock;
    TNodeManagerPtr NodeManager;
};

} // namespace NRateSrv::NRouter
