#pragma once

#include "serialization_helpers.h"

#include <mail/ratesrv/src/storage/protocol.h>

#include <mail/xiva/msgpack/include/msgpack.hpp>

#include <string>
#include <optional>

namespace NRateSrv::NRouter {

struct TMessengerRequest {
    ui64 RequestId;
    std::string ContextId;
    NStorage::TRequest StorageRequest;

    MSGPACK_DEFINE(RequestId, ContextId, StorageRequest);
};

struct TMessengerResponse {
    ui64 RequestId;
    NStorage::TResponse StorageResponse;

    MSGPACK_DEFINE(RequestId, StorageResponse);
};

using TPingPongMessage = ui64;

enum class EMessageTypes : unsigned int {
    GetRequest = 1,
    IncreaseRequest = 2,
    Response = 3,
    Ping = 4,
    Pong = 5
};

constexpr unsigned int GetMessageType(EMessageTypes type) noexcept {
    return static_cast<unsigned int>(type);
}

} // namespace NRateSrv::NRouter
