#pragma once

#include <yplatform/time_traits.h>

#include <util/system/spinlock.h>
#include <util/system/guard.h>

#include <string>

namespace NRateSrv::NRouter {

class TNode {
public:
    using TClock = yplatform::time_traits::clock;
    using TTimePoint = yplatform::time_traits::time_point;
    using TDuration = yplatform::time_traits::duration;

    TNode(std::string address, bool local);

    const std::string& GetAddress() const;
    bool IsLocal() const;

    bool IsBanned() const;
    bool AllowTryToResetBan();

    TDuration Ban(TDuration baseDuration, size_t quorum, bool force);
    int ResetBan(bool force);

    static TDuration CalcBanDuration(TDuration base, int num);

private:
    std::string Address;
    bool Local;

    int BanNumber;
    TTimePoint BannedUntil;

    size_t BanVotes;
    TTimePoint LastBanAttempt;

    size_t ResetBanVotes;
    size_t ResetBanAttempts;

    mutable TAdaptiveLock Lock;
};

} // namespace NRateSrv::NRouter
