#pragma once

#include "node_manager.h"
#include "network_agent.h"
#include "configuration.h"
#include "common.h"

#include <mail/ratesrv/src/context.h>
#include <mail/ratesrv/src/storage/protocol.h>

#include <yplatform/task_context.h>
#include <yplatform/reactor.h>
#include <yplatform/coroutine.h>
#include <yplatform/time_traits.h>

#include <boost/asio/io_context_strand.hpp>

#include <functional>
#include <unordered_map>

namespace NRateSrv::NRouter {

class TNodeClient {
public:
    using TTaskContextPtr = TContextPtr;
    using TCallback = std::function<void(size_t attempts, NStorage::TResponse response, NStorage::TRequest request)>;
    using TYieldCtx = yplatform::yield_context<TNodeClient>;

    TNodeClient(
        yplatform::reactor& reactor,
        TNetworkAgentPtr networkAgent,
        TNodeManagerPtr nodeManager,
        TConfigurationPtr configuration,
        TTaskContextPtr ctx,
        NStorage::TRequest request,
        ERequestMode mode,
        size_t nodeNum,
        TCallback callback);

    void operator()(TYieldCtx yieldCtx, ui64 requestId = 0, NStorage::TResponse response = {}, bool isTimeout = false);

private:
    bool SetDestination();
    void SendRequest(TYieldCtx yieldCtx);

    void SetTimer(TYieldCtx yieldCtx);
    void HandleTimeout();

private:
    boost::asio::io_context::strand Strand;
    yplatform::time_traits::timer Timer;

    TNetworkAgentPtr NetworkAgent;
    TNodeManagerPtr NodeManager;
    TConfigurationPtr Configuration;

    TTaskContextPtr Ctx;
    NStorage::TRequest Request;
    ERequestMode Mode;
    size_t NodeNum;
    TCallback Callback;

    size_t Attempts;
    ui64 CurrentRequestId;
    size_t Destination;
    std::unordered_map<size_t, size_t> NodeAttempts;
    TNodeManager::TUsedNumNodes UsedNodes;
};

} // namespace NRateSrv::NRouter
