#pragma once

#include "node.h"

#include <util/system/spinlock.h>
#include <util/system/guard.h>

#include <memory>
#include <vector>
#include <unordered_set>
#include <utility>

namespace NRateSrv::NRouter {

class TNodeManager {
public:
    using TUsedNumNodes = std::unordered_set<size_t>;
    using TNodes = std::vector<TNode>;

    explicit TNodeManager(TNodes nodes);

    TNode& Get(size_t nodeNum);
    const TNode& Get(size_t nodeNum) const;

    size_t Count() const;

    std::pair<bool, size_t> GetActing(size_t nodeNum, const TUsedNumNodes& usedNumNodes);

private:
    TNodes Nodes;

    TAdaptiveLock AlternateLock;
    std::vector<size_t> AlternateNodes;
    std::vector<size_t> AlternateCounts;
};

using TNodeManagerPtr = std::shared_ptr<TNodeManager>;

} // namespace NRateSrv::NRouter
