#include "router.h"
#include "router_impl.h"

#include <yplatform/module_registration.h>

namespace NRateSrv::NRouter {

TRouter::TRouter(yplatform::reactor& reactor)
    : Impl(std::make_shared<TRouterImpl>(reactor))
{}

void TRouter::init(const yplatform::ptree& configuration) {
    Impl->logger(logger());
    Impl->Init(configuration);
}

void TRouter::reload(const yplatform::ptree& configuration) {
    Impl->Reload(configuration);
}

void TRouter::stop() {
    Impl->Stop();
}

void TRouter::AsyncGet(TTaskContextPtr ctx, TCounterRequest request, TCallback callback) {
    Impl->AsyncGet(std::move(ctx), std::move(request), std::move(callback));
}

void TRouter::AsyncIncrease(TTaskContextPtr ctx, TCounterRequest request, TCallback callback) {
    Impl->AsyncIncrease(std::move(ctx), std::move(request), std::move(callback));
}

bool TRouter::IsReady() {
    return Impl->IsReady();
}

} // namespace NRateSrv::NRouter

REGISTER_MODULE(NRateSrv::NRouter::TRouter)
