#pragma once

#include "common.h"
#include "router_impl.h"


#include <mail/ratesrv/src/context.h>
#include <mail/ratesrv/src/common/types.h>

#include <yplatform/task_context.h>
#include <yplatform/module.h>
#include <yplatform/ptree.h>
#include <yplatform/reactor.h>

#include <memory>

namespace NRateSrv::NRouter {

class TRouter : public yplatform::module {
public:
    using TTaskContextPtr = TContextPtr;

    explicit TRouter(yplatform::reactor& reactor);

    void init(const yplatform::ptree& configuration);
    void reload(const yplatform::ptree& configuration);
    void stop();

    void AsyncGet(TTaskContextPtr ctx, TCounterRequest request, TCallback callback);
    void AsyncIncrease(TTaskContextPtr ctx, TCounterRequest request, TCallback callback);

    bool IsReady();

private:
    std::shared_ptr<TRouterImpl> Impl;
};

} // namespace NRateSrv::NRouter
