#pragma once

#include "counters_worker.h"
#include "network_agent_impl.h"
#include "configuration.h"
#include "common.h"

#include <mail/ratesrv/src/context.h>

#include <yplatform/reactor.h>
#include <yplatform/log.h>

#include <atomic>
#include <memory>
#include <vector>

namespace NRateSrv::NRouter {

class TRouterImpl : public yplatform::log::contains_logger, public std::enable_shared_from_this<TRouterImpl> {
public:
    using TTaskContextPtr = TContextPtr;

    explicit TRouterImpl(yplatform::reactor& reactor);

    void Init(const yplatform::ptree& configuration);
    void Reload(const yplatform::ptree& configuration);
    void Stop();

    void AsyncGet(TTaskContextPtr ctx, TCounterRequest request, TCallback callback);
    void AsyncIncrease(TTaskContextPtr ctx, TCounterRequest request, TCallback callback);

    bool IsReady();

private:
    void ReadConfiguration(const yplatform::ptree& configuration);

    void ReadHostsConfiguration();
    void CloudHostlist();
    void SetHosts(const std::string& localhost, std::vector<std::string> hosts);

    void CreateWorker(TTaskContextPtr ctx, TCounterRequest request, TCallback callback, bool increase);

private:
    enum class EHostsUpdateMethod {
        File,
        CloudApi
    };

    yplatform::reactor& Reactor;
    TConfigurationPtr Configuration;
    std::shared_ptr<TNetworkAgentImpl> NetworkAgent;
    std::atomic_bool Ready;
    EHostsUpdateMethod HostsUpdateMethod;
    std::string HostsFile;
    std::vector<std::uint64_t> SchedulerGroupIds;
    yplatform::time_traits::duration HostlistPeriod = yplatform::time_traits::seconds(60);
    std::vector<std::string> CurrentHosts;
};

} // namespace NRateSrv::NRouter
