#pragma once

#include <mail/ratesrv/src/storage/protocol.h>
#include <mail/ratesrv/src/common/types.h>

#include <mail/xiva/msgpack/include/msgpack.hpp>

#include <tuple>

MSGPACK_ADD_ENUM(NRateSrv::ECounterState);

namespace msgpack::adaptor {

using namespace NRateSrv;

template <>
struct convert<NStorage::TRequest::TKey> {
    msgpack::object const& operator()(msgpack::object const& object, NStorage::TRequest::TKey& value) const {
        auto tuple = std::tie(value.Domain, value.Key, value.Index, value.Value, value.Bucket);
        object.convert(tuple);
        return object;
    }
};

template <>
struct pack<NStorage::TRequest::TKey> {
    template <typename Stream>
    msgpack::packer<Stream>& operator()(msgpack::packer<Stream>& packer, NStorage::TRequest::TKey const& value) const {
        packer.pack(std::tie(value.Domain, value.Key, value.Index, value.Value, value.Bucket));
        return packer;
    }
};

template <>
struct convert<NStorage::TRequest> {
    msgpack::object const& operator()(msgpack::object const& object, NStorage::TRequest& value) const {
        NStorage::TRequest::TGroups groups;
        object.convert(groups);
        value.SetGroups(std::move(groups));
        return object;
    }
};

template <>
struct pack<NStorage::TRequest> {
    template <typename Stream>
    msgpack::packer<Stream>& operator()(msgpack::packer<Stream>& packer, NStorage::TRequest const& value) const {
        packer.pack(value.GetRefGroups());
        return packer;
    }
};

template <>
struct convert<TCounterValue> {
    msgpack::object const& operator()(msgpack::object const& object, TCounterValue& value) const {
        auto tuple = std::tie(value.State, value.Current, value.Available);
        object.convert(tuple);
        return object;
    }
};

template <>
struct pack<TCounterValue> {
    template <typename Stream>
    msgpack::packer<Stream>& operator()(msgpack::packer<Stream>& packer, TCounterValue const& value) const {
        packer.pack(std::tie(value.State, value.Current, value.Available));
        return packer;
    }
};

} // namespace msgpack::adaptor
