#include "storage_client.h"

#include <mail/ratesrv/src/storage/interface.h>

#include <yplatform/find.h>
#include <yplatform/yield.h>

namespace NRateSrv::NRouter {

TStorageClient::TStorageClient(NStorage::TRequest request, ERequestMode mode, NRouter::TStorageCallback callback)
    : Request(std::move(request))
    , Mode(mode)
    , Callback(std::move(callback))
{}

void TStorageClient::operator()(TYieldCtx yieldCtx) {
    reenter (yieldCtx) {
        yield SendRequestToStorage(yieldCtx);

        Complete();
    }
}

void TStorageClient::SendRequestToStorage(TCallback callback) {
    try {
        auto storage = yplatform::find<NStorage::IStorage>("storage");
        switch (Mode) {
            case ERequestMode::Get:
                Response = storage->Get(std::move(Request));
                break;
            case ERequestMode::Increase:
                Response = storage->Increase(std::move(Request));
                break;
        }
    } catch (...) {
    }

    callback();
}

void TStorageClient::Complete() {
    Callback(std::move(Response));
}

} // namespace NRateSrv::NRouter
