#pragma once

#include "common.h"

#include <mail/ratesrv/src/storage/protocol.h>
#include <mail/ratesrv/src/common/types.h>

#include <yplatform/coroutine.h>

#include <functional>

namespace NRateSrv::NRouter {

class TStorageClient {
public:
    using TCallback = std::function<void()>;
    using TYieldCtx = yplatform::yield_context<TStorageClient>;

    TStorageClient(NStorage::TRequest request, ERequestMode mode, NRouter::TStorageCallback callback);

    void operator()(TYieldCtx yieldCtx);

private:
    void SendRequestToStorage(TCallback callback);
    void Complete();

private:
    NStorage::TRequest Request;
    ERequestMode Mode;
    NRouter::TStorageCallback Callback;
    NStorage::TResponse Response;
};

} // namespace NRateSrv::NRouter
