#include "util.h"

#include <library/cpp/consistent_hashing/consistent_hashing.h>

#include <util/digest/city.h>

namespace NRateSrv::NRouter {

bool SplitName(const std::string& key, TSplitName& res) {
    size_t groupPos = 0;
    size_t limitPos = 0;

    groupPos = key.find_first_of(':');
    groupPos = groupPos != std::string::npos ? groupPos : 0;
    if (groupPos != 0) {
        limitPos = key.find_first_of(':', groupPos + 1);
        limitPos = limitPos != std::string::npos ? limitPos : 0;
    }
    if (limitPos <= groupPos + 1 || key.size() == limitPos + 1) {
       return false;
    }

    res.Group = key.substr(0, groupPos);
    res.Key = key.substr(limitPos + 1);

    auto limit = key.substr(groupPos + 1, limitPos - groupPos - 1);
    size_t atPos = limit.find_first_of('@');

    if (atPos != std::string::npos) {
        if (atPos == 0) {
            return false;
        }
        res.Limit = limit.substr(0, atPos);
        res.Domain = limit.substr(atPos + 1);
    } else {
        res.Limit = std::move(limit);
    }

    return true;
}

size_t CalcBucketNumber(const std::string& key, size_t bucketCount, ui64 seed) {
    ui64 hashVal = CityHash64WithSeed(key.c_str(), key.size(), seed);
    return ConsistentHashing(hashVal, bucketCount);
}

size_t CalcNodeNumber(size_t bucket, size_t nodeCount, std::string salt, ui64 seed) {
    salt += std::to_string(bucket);
    ui64 hashVal = CityHash64WithSeed(salt.c_str(), salt.size(), seed);
    return ConsistentHashing(hashVal, nodeCount);
}

std::string ExtractPort(const std::string& address) {
    auto pos = address.find_last_of(':');
    if (pos == std::string::npos || pos + 1 == address.size()) {
        return {};
    }
    return address.substr(pos + 1);
}

} // namespace NRateSrv::NRouter
