#pragma once

#include <util/system/types.h>

#include <string>

namespace NRateSrv::NRouter {

struct TSplitName {
    std::string Group;
    std::string Limit;
    std::string Domain;
    std::string Key;
};

bool SplitName(const std::string& key, TSplitName& res);

size_t CalcBucketNumber(const std::string& key, size_t bucketCount, ui64 seed);

size_t CalcNodeNumber(size_t bucket, size_t nodeCount, std::string salt, ui64 seed);

std::string ExtractPort(const std::string& address);

} // namespace NRateSrv::NRouter
