#pragma once

#include <yplatform/time_traits.h>

#include <exception>
#include <functional>

namespace NRateSrv::NScheduler {

using TDuration = yplatform::time_traits::duration;
using TTaskErrorHandler = std::function<void(std::exception_ptr exceptionPtr)>;

enum class EExecutionPolicyWhenTaskAdding {
    RunOne,
    RunAll,
    WaitInLine,
};

struct TGroupSettings {
    TDuration Duration = TDuration::zero();
    TTaskErrorHandler TaskErrorHandler;
    EExecutionPolicyWhenTaskAdding Policy = EExecutionPolicyWhenTaskAdding::WaitInLine;
};

} // namespace NRateSrv::NScheduler
