#include "scheduler.h"
#include "scheduler_impl.h"

#include <yplatform/module_registration.h>

namespace NRateSrv::NScheduler {

TScheduler::TScheduler(yplatform::reactor& reactor)
    : Impl(std::make_unique<TSchedulerImpl>(reactor))
{}

void TScheduler::init() {
    Impl->logger(logger());
}

void TScheduler::stop() {
    Impl->Stop();
}

ui64 TScheduler::CreateGroup(TGroupSettings settings) {
    return Impl->CreateGroup(std::move(settings));
}

void TScheduler::RemoveGroup(ui64 groupId) {
    Impl->RemoveGroup(groupId);
}

ui64 TScheduler::AddTask(ITaskPtr&& task, ui64 groupId) {
    return Impl->AddTask(std::move(task), groupId);
}

std::vector<ui64> TScheduler::AddTasks(std::vector<ITaskPtr>&& tasks, ui64 groupId) {
    return Impl->AddTasks(std::move(tasks), groupId);
}

void TScheduler::RemoveTask(ui64 taskId, ui64 groupId) {
    Impl->RemoveTask(taskId, groupId);
}

} // namespace NRateSrv::NScheduler

REGISTER_MODULE(NRateSrv::NScheduler::TScheduler)
