#pragma once

#include "task.h"
#include "group_settings.h"

#include <yplatform/module.h>
#include <yplatform/reactor.h>

#include <util/system/types.h>

#include <memory>
#include <vector>

namespace NRateSrv::NScheduler {

class TSchedulerImpl;

class TScheduler : public yplatform::module {
public:
    explicit TScheduler(yplatform::reactor& reactor);

    void init();
    void stop();

    ui64 CreateGroup(TGroupSettings settings);
    void RemoveGroup(ui64 groupId);

    ui64 AddTask(ITaskPtr&& task, ui64 groupId);
    std::vector<ui64> AddTasks(std::vector<ITaskPtr>&& tasks, ui64 groupId);
    void RemoveTask(ui64 taskId, ui64 groupId);

private:
    std::unique_ptr<TSchedulerImpl> Impl;
};

} // namespace NRateSrv::NScheduler
