#pragma once

#include <util/system/types.h>

#include <chrono>
#include <string>
#include <unordered_map>

namespace NRateSrv::NStorage {

using TClock = std::chrono::system_clock;
using TTimepoint = TClock::time_point;
using TInterval = std::chrono::milliseconds;

struct TLimitConf {
    ui64 Threshold = 0;
    ui64 RecoveryRate = 0;
    TInterval RecoveryInterval = TInterval::zero();
    bool IgnoreThreshold = false;
};

struct TCounter {
    ui64 Value = 0;
    TTimepoint LastUpdate = TTimepoint::min();
    size_t Bucket = 0;

    bool operator==(const TCounter& other) const {
        return Value == other.Value && LastUpdate == other.LastUpdate && Bucket == other.Bucket;
    }
};

} // namespace NRateSrv::NStorage
