#pragma once

#include "common.h"

#include <mail/ratesrv/src/common/types.h>

namespace NRateSrv::NStorage {

class TCounterUpdater {
public:
    TCounterUpdater(
        TCounterValue& value,
        const TLimitConf& configuration,
        ui64 increaseValue = 0,
        size_t bucket = 0);

    TCounter operator()(const TCounter* counter);

    static i64 CalcAvailable(ui64 current, ui64 limit);

private:
    TCounter Update(const TCounter* counter);
    TCounter Create();

private:
    TCounterValue& Value;
    const TLimitConf& Configuration;
    ui64 IncreaseValue;
    size_t Bucket;
};

} // namespace NRateSrv::NStorage
