#pragma once

#include "repository.h"
#include "protocol.h"
#include "common.h"

#include <memory>
#include <string>
#include <unordered_map>

namespace NRateSrv::NStorage {

class TDatabase {
public:
    struct TLimit {
        explicit TLimit(size_t partCount)
            : Repository(std::make_shared<TRepository>(partCount))
        {}

        TRepositoryPtr Repository;
        std::unordered_map<std::string, TLimitConf> Configuration;
    };

    struct TGroup {
        std::unordered_map<std::string, TLimit> Limits;
    };

    using TGroups = std::unordered_map<std::string, TGroup>;

    void Init(TGroups&& groups);

    TResponse Get(TRequest request);
    TResponse Increase(TRequest request);

    size_t Size();

private:
    TResponse ProcessGroups(TRequest::TGroups groups, bool isIncrease);
    TResponse ProcessLimits(TGroup* group, TRequest::TLimits limits, bool isIncrease);
    TResponse ProcessKeys(TGroup* group, TLimit* limit, TRequest::TKeys keys, bool isIncrease);

private:
    TGroups Groups;
};

using TDatabasePtr = std::shared_ptr<TDatabase>;

} // namespace NRateSrv::NStorage
