#pragma once

#include "database.h"
#include "common.h"

#include <mail/ratesrv/src/scheduler/task.h>
#include <mail/ratesrv/src/logger.h>

#include <atomic>

namespace NRateSrv::NStorage {

class TDatabaseSizeTask : public NScheduler::ITask {
public:
    TDatabaseSizeTask(TDatabasePtr db):
        Db(std::move(db)) {
    }

    void Run() override {
        if (Cancelled.load(std::memory_order_acquire)) {
            return;
        }

        RATESRV_LOG_COUNTER_NOCTX(notice, "database_size", Db->Size());
    }

    void Cancel() override {
        Cancelled.store(true, std::memory_order_release);
    }

private:
    TDatabasePtr Db;
    std::atomic_bool Cancelled;
};

} // namespace NRateSrv::NStorage
