#include "gc_task.h"

namespace NRateSrv::NStorage {

TGcTask::TGcTask(TRepositoryPtr repository, TInterval ttl)
    : Repository(std::move(repository))
    , Ttl(ttl)
    , Cancelled(false)
{}

void TGcTask::Run() {
    TRepository::TEraseKeys keys;
    auto timePoint = TClock::now() - Ttl;

    Repository->Read([this, timePoint, &keys](const std::string& key, const TCounter& counter) -> bool {
        if (Cancelled.load(std::memory_order_acquire)) {
            return false;
        }
        if (counter.LastUpdate < timePoint) {
            keys.push_back(key);
        }
        return true;
    });

    if (Cancelled.load(std::memory_order_acquire)) {
        return;
    }

    Repository->Erase(std::move(keys), [timePoint](const TCounter& counter) {
        return counter.LastUpdate < timePoint;
    });
}

void TGcTask::Cancel() {
    Cancelled.store(true, std::memory_order_release);
}

} // namespace NRateSrv::NStorage
