#pragma once

#include <mail/ratesrv/src/common/types.h>

#include <util/system/types.h>
#include <library/cpp/json/json_value.h>
#include <util/string/cast.h>

#include <string>
#include <unordered_map>
#include <vector>

namespace NRateSrv::NStorage {

class TRequest {
public:
    struct TKey {
        std::string Domain;
        std::string Key;
        size_t Index = 0;
        ui64 Value = 0;
        size_t Bucket = 0;

        [[nodiscard]] NJson::TJsonValue ToJson() const noexcept {
            NJson::TJsonValue json;
            json["domain"] = ToString(Domain);
            json["key"] = ToString(Key);
            json["index"] = Index;
            json["value"] = Value;
            json["bucket"] = Bucket;
            return json;
        }

        bool operator==(const TKey& other) const {
            return
                Domain == other.Domain &&
                Key == other.Key &&
                Index == other.Index &&
                Value == other.Value &&
                Bucket == other.Bucket;
        }
    };

    void Add(
        const std::string& group,
        const std::string& limit,
        std::string domain,
        std::string key,
        size_t index,
        ui64 value,
        size_t bucket)
    {
        TKey elem{std::move(domain), std::move(key), index, value, bucket};
        Groups[group][limit].push_back(std::move(elem));
    }

    using TKeys = std::vector<TKey>;
    using TLimits = std::unordered_map<std::string, TKeys>;
    using TGroups = std::unordered_map<std::string, TLimits>;

    TGroups GetGroups() {
        TGroups groups;
        std::swap(groups, Groups);
        return groups;
    }

    [[nodiscard]] NJson::TJsonValue ToJson() const noexcept {
        NJson::TJsonValue json;
        for (auto&& [groupName, limits] : Groups) {
            NJson::TJsonValue group;
            for (auto&& [keyName, keys] : limits) {
                NJson::TJsonValue jsonKeys = NJson::EJsonValueType::JSON_ARRAY;
                for (auto&& key : keys) {
                    jsonKeys.AppendValue(key.ToJson());
                }
                group[keyName] = jsonKeys;
            }
            json[groupName] = group;
        }
        return json;
    }

    const TGroups& GetRefGroups() const {
        return Groups;
    }

    void SetGroups(TGroups&& groups) {
        Groups = std::move(groups);
    }

    bool operator==(const TRequest& other) const {
        return Groups == other.Groups;
    }

private:
    TGroups Groups;
};

using TResponse = std::unordered_map<size_t, TCounterValue>;

} // namespace NRateSrv::NStorage
