#pragma once

#include "common.h"

#include <mail/xiva/msgpack/include/msgpack.hpp>

#include <tuple>

namespace msgpack::adaptor {

using namespace NRateSrv::NStorage;

template <>
struct convert<TCounter> {
    msgpack::object const& operator()(msgpack::object const& object, TCounter& value) const {
        TTimepoint::duration::rep ticks;
        auto tuple = std::tie(value.Value, ticks, value.Bucket);
        object.convert(tuple);
        value.LastUpdate = TTimepoint(TTimepoint::duration(ticks));
        return object;
    }
};

template <>
struct pack<TCounter> {
    template <typename Stream>
    msgpack::packer<Stream>& operator()(msgpack::packer<Stream>& packer, TCounter const& value) const {
        auto ticks = value.LastUpdate.time_since_epoch().count();
        packer.pack(std::tie(value.Value, ticks, value.Bucket));
        return packer;
    }
};

} // namespace msgpack::adaptor
